package nestedstate;

/**
* Transitions are created on the fly and should not be created manually.
*/
class Transition
{
        LeafState target;
        LeafState source;
        
        FSMAction action;
        
        public Transition(LeafState s, LeafState t, FSMAction a)
        {
                source = s;
                target = t;
                action = a;
        }
                
        public void execute(FSMContext fsmc, Object data)
        {
                // trigger a state exit event in the old state
                // execute the action
                source.getStateExitAction().execute(fsmc, data);
                if(action != null)
                        action.execute(fsmc, data);
                
                target.getParent().setState(target);
                
                //source.getParent().setState(target);
                target.getStateEntryAction().execute(fsmc, data);
        }                
}
